/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.allsky.Action;
import cds.allsky.BuilderSMoc;
import cds.allsky.Context;
import cds.moc.SMoc;
import cds.moc.TMoc;
import cds.tools.Astrodate;
import cds.tools.pixtools.Util;
import java.io.File;

public class BuilderTMoc
extends BuilderSMoc {
    private int mode = 0;
    private TMoc tmoc = null;
    private static final int UNKNOWN = 0;
    private static final int TMIN = 1;
    private static final int MJD = 2;
    private static final int DATEOBS = 3;
    private static final int DATEOBS12 = 4;
    private static final int OBSDATE = 5;
    private final String[] TIMEMODE = new String[]{"UNKNOWN", "T_MIN/T_MAX", "MJD-OBS/EXPTIME", "DATE-OBS/EXPTIME", "DATEOBS1/DATEOBS2", "OBS-DATE+TIME-OBS"};

    public BuilderTMoc(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.TMOC;
    }

    private double parseDouble(String s) throws Exception {
        int n = s.length() - 1;
        if (s.charAt(n) == '.') {
            s = s.substring(0, n);
        }
        return Double.parseDouble(s);
    }

    @Override
    protected TMoc getTMoc(int order, String json) throws Exception {
        double tmin = 0.0;
        double tmax = 0.0;
        if (this.mode == 0) {
            this.mode = this.detectMode(json);
            this.context.info("Time extraction from " + this.getTimeMode(this.mode) + " keywords");
        }
        try {
            String s;
            if (this.mode == 1) {
                s = cds.tools.Util.extractJSON("T_MIN", json);
                if (s == null) {
                    throw new Exception();
                }
                tmin = this.parseDouble(s);
                s = cds.tools.Util.extractJSON("T_MAX", json);
                tmax = s == null ? tmin : this.parseDouble(s);
            } else if (this.mode == 4) {
                s = cds.tools.Util.extractJSON("DATEOBS1", json);
                if (s == null) {
                    throw new Exception();
                }
                tmin = Astrodate.JDToMJD(Astrodate.parseTime(s, 15));
                s = cds.tools.Util.extractJSON("DATEOBS2", json);
                if (s == null) {
                    throw new Exception();
                }
                tmax = Astrodate.JDToMJD(Astrodate.parseTime(s, 15));
                if (Double.isNaN(tmax)) {
                    tmax = tmin;
                }
            } else if (this.mode == 2) {
                s = cds.tools.Util.extractJSON("MJD-OBS", json);
                if (s == null) {
                    throw new Exception();
                }
                tmin = Double.parseDouble(s);
                s = cds.tools.Util.extractJSON("EXPTIME", json);
                if (s == null) {
                    tmax = tmin;
                } else {
                    double exptime = this.parseDouble(s);
                    tmax = tmin + exptime;
                }
            } else if (this.mode == 3) {
                s = cds.tools.Util.extractJSON("DATE-OBS", json);
                if (s == null) {
                    throw new Exception();
                }
                tmin = Astrodate.JDToMJD(Astrodate.parseTime(s, 15));
                s = cds.tools.Util.extractJSON("EXPTIME", json);
                if (s == null) {
                    tmax = tmin;
                } else {
                    double exptime = this.parseDouble(s);
                    tmax = tmin + exptime;
                }
            } else if (this.mode == 5) {
                s = cds.tools.Util.extractJSON("OBS-DATE", json);
                if (s == null) {
                    throw new Exception();
                }
                String s1 = cds.tools.Util.extractJSON("TIME-OBS", json);
                s1 = s1 == null ? "" : "T" + s1;
                tmin = Astrodate.JDToMJD(Astrodate.parseTime(s + s1, 15));
                s = cds.tools.Util.extractJSON("EXPTIME", json);
                if (s == null) {
                    tmax = tmin;
                } else {
                    double exptime = this.parseDouble(s);
                    tmax = tmin + exptime;
                }
            }
            double jdtmin = tmin + 2400000.5;
            double jdtmax = tmax + 2400000.5;
            if (jdtmax < jdtmin) {
                this.context.warning("Bad time range [" + jdtmin + ".." + jdtmax + "] => assuming jdtmax..jdtmin =>[" + json + "]");
                double t = jdtmax;
                jdtmax = jdtmin;
                jdtmin = t;
            }
            TMoc tmoc = new TMoc(order);
            tmoc.add(jdtmin, jdtmax);
            return tmoc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void initIt() throws Exception {
        this.tmoc = new TMoc(this.timeOrder);
        this.tmoc.bufferOn();
    }

    @Override
    protected void info() {
        String s = this.maxSize > 0L ? " maxSize=" + cds.tools.Util.getUnitDisk(this.maxSize) : "";
        String s1 = this.tmoc.getMem() > 0L ? " currentSize=" + cds.tools.Util.getUnitDisk(this.tmoc.getMem()) : "";
        this.context.info("TMOC generation (timeOrder=" + this.tmoc.getTimeOrder() + s + s1 + ")...");
    }

    @Override
    protected void addIt(TMoc tmoc1, SMoc smoc1) throws Exception {
        this.tmoc.add(tmoc1);
        this.adjustSize(this.tmoc, false);
    }

    @Override
    protected void cleanIt() throws Exception {
        String file = this.context.getOutputPath() + Util.FS + "TMoc.fits";
        new File(file).delete();
    }

    @Override
    protected void writeIt() throws Exception {
        this.adjustSize(this.tmoc, true);
        if (this.tmoc.isEmpty()) {
            throw new Exception("Empty MOC => not generated");
        }
        String file = this.context.getOutputPath() + Util.FS + "TMoc.fits";
        this.tmoc.write(file);
    }

    private String getTimeMode(int i) {
        return this.TIMEMODE[i];
    }

    private int detectMode(String json) throws Exception {
        String s1 = cds.tools.Util.extractJSON("T_MIN", json);
        if (s1 != null) {
            return 1;
        }
        s1 = cds.tools.Util.extractJSON("MJD-OBS", json);
        if (s1 != null) {
            return 2;
        }
        s1 = cds.tools.Util.extractJSON("DATE-OBS", json);
        if (s1 != null) {
            return 3;
        }
        s1 = cds.tools.Util.extractJSON("OBS-DATE", json);
        if (s1 != null) {
            return 5;
        }
        s1 = cds.tools.Util.extractJSON("DATEOBS1", json);
        String s2 = cds.tools.Util.extractJSON("DATEOBS2", json);
        if (s1 != null && s2 != null) {
            return 4;
        }
        this.context.error("Not able to determine HpxFinder time keywords (ex: T_MIN [and T_MAX] or MJD-OBS [and EXPTIME], or DATE-OBS [and EXPTIME],  or DATEOBS1 and DATEOBS2, or OBS-DATE+TIME-OBS");
        throw new BuilderSMoc.MocParsingException();
    }
}

